/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.summon_charms;

import com.hollingsworth.arsnouveau.api.item.AbstractSummonCharm;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CauldronBlock;
import org.jetbrains.annotations.NotNull;

public class WixieCharm
extends AbstractSummonCharm
implements AliasProvider {
    public WixieCharm() {
        super(ItemsRegistry.defaultItemProperties().component(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData().setColor("black")));
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        return super.useOn(context);
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context, Level world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() instanceof CauldronBlock) {
            world.setBlockAndUpdate(pos, BlockRegistry.WIXIE_CAULDRON.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult useOnSummonTile(UseOnContext context, Level world, SummoningTile tile, BlockPos pos) {
        if (tile instanceof WixieCauldronTile) {
            WixieCauldronTile cauldronTile = (WixieCauldronTile)tile;
            if (cauldronTile.hasWixie()) {
                PortUtil.sendMessage((Entity)context.getPlayer(), (Component)Component.translatable((String)"ars_nouveau.wixie.has_wixie"));
            } else {
                EntityWixie wixie = new EntityWixie(world, pos);
                wixie.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                wixie.fromCharmData((PersistentFamiliarData)context.getItemInHand().getOrDefault(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData()));
                world.addFreshEntity((Entity)wixie);
                cauldronTile.entityID = wixie.getId();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public Collection<AliasProvider.Alias> getAliases() {
        return List.of(new AliasProvider.Alias("auto_crafter", "Auto Crafter"), new AliasProvider.Alias("potion_brewer", "Potion Brewer"), new AliasProvider.Alias("brewing_stand", "Brewing Stand"));
    }
}

